| package |
package := Package name: 'Pst-GEOS-Dolphin'.
package paxVersion: 0;
	basicComment: ''.

package basicPackageVersion: ''.

"Add the package scripts"

"Add the class names, loose method names, global names, resource names"
package classNames
	yourself.

package methodNames
	add: #PstConstantsBrowser -> #addGeosLibrary;
	add: #PstLauncher -> #newProjectGeos;
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Dolphin';
	add: 'Pst-Base';
	add: 'Pst-GEOS-Base';
	add: 'Pst-Ui-Dolphin';
	yourself).

package!

"Class Definitions"!

"Loose Methods"!

!PstConstantsBrowser methodsFor!

addGeosLibrary
	| filename name |
	filename := FileOpenDialog new
		fileTypes: (Array
			with: #('GEOS Dynamic Libraries (*.geo)' '*.geo')
			with: #('GEOS Library Definition (*.ldf)' '*.ldf')
			with: FileDialog allFilesType);
		caption: 'Select Geos Library';
		defaultExtension: 'geo';
		showModal.
	(filename isNil or: [filename isEmpty]) ifTrue: [^self].
	self model ensureCategoryExists: 'Geos Libraries'.
	name := self model nextGeosLibraryConstantName.
	self model
		define: name
		as: (PstByteIndexableObject newString: filename)
		classified: 'Geos Libraries'.
	self selectConstant: (self model constantNamed: name).! !
!PstConstantsBrowser categoriesFor: #addGeosLibrary!*-unclassified!public! !

!PstLauncher methodsFor!

newProjectGeos

	self newProjectOfType: PstPocketSmalltalkGEOS.! !
!PstLauncher categoriesFor: #newProjectGeos!actions-system!public! !

"End of package definition"!

 
"Binary Globals"!

"Resources"!

